#############################################
#                                           #
#        W11 Compatibility Check            #  
#                                           #
#                 EGIS                      #
#		                            #
#          Jerry stole it from              #
#					    #								
#       Jonathan Keesling 6/13/2023         # 
#                                           #
#############################################

#scan for W11 results, emails results to given address. 


#Settings to change
########################################################################################                                                                                                 
#path to output report file                                                            
$path = "C:\egistemp\W11results.txt"

#path to output zip file
$zipPath = "c:\egistemp\results.zip"                                                                 
                                                                                       
#where are the email alerts sent to                                                    
$emailRecipients = "sbailey@egis-security.com" , "jjohnson@egis-security.com"
########################################################################################


#email configuration, normally static
########################################################################################
$Username = "egis.w11@egisnetworks.com"


[Byte[]] $key = (71,35,43,51,56,60,73,82,84,90,91,6,12,29,31,31)                       
$pwFile = "C:\egistemp\data.txt"
$machine = hostname
$scanDate = Get-Date -Format "MM/dd/yyyy HH:mm"                                                               
########################################################################################



#read cred file for emailing
#$MySecureCreds = New-Object -TypeName System.Management.Automation.PSCredential -ArgumentList $Username, $Credplain
$MySecureCreds = New-Object -TypeName System.Management.Automation.PSCredential -ArgumentList $Username, (Get-Content $pwFile | ConvertTo-SecureString -Key $key)

#compress results file
Compress-Archive -LiteralPath $path -DestinationPath $zipPath -Force

#check if output file contains found string or not
$match = Select-String -Path $path -Pattern "NOT CAPABLE"

#gets contents of result file
$results = Get-Content 'c:\egistemp\w11results.txt'

if ($match -ne $null)
{
    #string match found --> not W11 Compatible
    $emailsub = $machine + " "+ $env:USERDNSDomain +": " + "NOT CAPABLE"
    $emailbod = "Machine: " + $machine + "`n" + "Domain: " + $env:USERDNSDomain + "`n" + "Scan date: " + $scanDate + "`n" + "NOT W11 Capable" + "`n Results from W11 compatibility scan: `n`n" + $results
}

elseif ($match -eq $null)
{
    #string match not found --> W11 Compatible

    #in this case the body contains the result file
    $emailsub = $machine + " "+ $env:USERDNSDomain +": " + "IS W11 CAPABLE"

    #header placed before results
    $emailbod ="Machine: " + $machine + "`n" + "Domain: " + $env:USERDNSDomain + "`n" + "Scan date: " + $scanDate + "`n" + "IS W11 Capable" + "`n Results from W11 compatibility scan: `n`n" + $results
       
}

#send email
#$zipPath = "c:\egistemp\w11results.txt"

Send-MailMessage -To $emailRecipients -Subject $emailsub -Body $emailbod -UseSsl -Port 587 -SmtpServer "mail.egisnetworks.com" -From $Username -Credential $MySecureCreds





